//Source file: F:\jschwartz\src\Alkindi\BusinessDataTypes\Product.java

/* Copyright (C) 2000 Alikindi, LLC */

package Alkindi.Data;

import java.io.Serializable;

/* 
$Header: Product.java, 14, 2/23/01 4:35:15 PM, Schwartz, Joe$
$Log: 
 14   Alkindi Development1.13        2/23/01 4:35:15 PM   Schwartz, Joe  
      Changed documentation.
 13   Alkindi Development1.12        2/12/01 4:47:13 PM   Schwartz, Joe  
      Changed Product ID to use int storage.
 12   Alkindi Development1.11        1/2/01 3:39:29 PM    Schwartz, Joe  
      Replaced comparable interface, which was missing by accident.
 11   Alkindi Development1.10        12/28/00 1:06:53 PM  Schwartz, Joe   Added
      version control header info.
 10   Alkindi Development1.9         12/26/00 7:21:16 PM  Schwartz, Joe   
 9    Alkindi Development1.8         12/26/00 6:57:24 PM  Schwartz, Joe   
 8    Alkindi Development1.7         12/18/00 12:05:38 PM Schwartz, Joe   Moved
      internal data classes to Utils package & regenerated classes from Rose.
 7    Alkindi Development1.6         12/15/00 6:21:28 PM  Schwartz, Joe   Added
      equals() and hashCode() operations. hashCode is for HashMap collections
      that key on Product objects.
 6    Alkindi Development1.5         12/2/00 1:01:53 PM   Schwartz, Joe   
 5    Alkindi Development1.4         11/14/00 12:53:14 PM Schwartz, Joe   
 4    Alkindi Development1.3         10/30/00 7:52:22 PM  Schwartz, Joe   
 3    Alkindi Development1.2         10/19/00 1:12:16 PM  Schwartz, Joe   After
      10.19 Appian Delivery
 2    Alkindi Development1.1         10/6/00 4:13:38 PM   Schwartz, Joe   
 1    Alkindi Development1.0         9/21/00 4:11:13 PM   Schwartz, Joe   
$
$NoKeywords$
 */

/**
 * This class represents a single product.
 */
public class Product implements Serializable, Comparable 
{
	
	/**
	 * The Alkindi ID of the Product. This identifier is unique within the Alkindi system.
	 */
	public int id;
	
	/**
	 * The Type ID of the Product.
	 */
	public int type;
	
	public Product() 
	{
	}
	
	/**
	 * Constructs a new product with the specified ID.
	 * @roseuid 39E214480148
	 */
	public Product(final int idIn) 
	{
		id = idIn;
	}
	
	/**
	 * Constructs a new product with the specified ID and Type.
	 * @roseuid 39EF27F1037A
	 */
	public Product(final int typeIn, final int idIn) 
	{
		id = idIn;
		type = typeIn;
	}
	
	/**
	 * Provides an override of java.lang.Object.compareTo() for the interfaces which requrie "natural ordering."
	 * @roseuid 3A291DDE02AF
	 */
	public int compareTo(Object objCompare) 
	{
		return (this.id - ((Product)objCompare).id);
	}
	
	/**
	 * Provides simple equality testing. Overrides java.lang.Object.equals().
	 * @roseuid 3A3A6EA8001F
	 */
	public boolean equals(java.lang.Object src) 
	{
		if (src == null)
			return false;
		return id == ((Product)src).id;
	}
	
	/**
	 * This returns a hash code for the use of Collections interfaces that need one. The hash code is the value of the product id expressed as an integer.
	 * @roseuid 3A3A6EAC0138
	 */
	public int hashCode() 
	{
		return (int)id;
	}
}
